definition module CMVisualization

import CMTypes
import CMUtilities
import iDataFormlib
import StdiTasks


// View types	         
:: HtmlPrompt = HtmlPrompt String 

derive gForm  HtmlPrompt
derive gUpd   HtmlPrompt
derive gParse HtmlPrompt
derive gPrint HtmlPrompt

                
:: HtmlPaper = HtmlPaper Paper

derive gForm  HtmlPaper
derive gUpd   HtmlPaper
derive gParse HtmlPaper
derive gPrint HtmlPaper     


:: HtmlMatrix a = HtmlMatrix [String] [String] [[a]]

derive gForm  HtmlMatrix
derive gUpd   HtmlMatrix
derive gParse HtmlMatrix
derive gPrint HtmlMatrix        


:: FixedList a = HorList [a]
               | VerList [a]

derive gForm  FixedList
derive gUpd   FixedList
derive gParse FixedList
derive gPrint FixedList


// Formatting functions for users
formatUserList :: ([User] -> HtmlCode)

userFormat :: [(String, User -> String)]
             
              
// Formatting functions for papers   
formatPaperList :: ([Paper] -> HtmlCode)

paperFormat :: [(String, Paper -> String)]
             
            
// Formatting functions for reviews                                   
formatReviewList :: ([Review] -> HtmlCode)

reviewFormat :: [(String, Review -> String)]
               
expertiseScale :: [String]

verdictScale :: [String]


// General formatting functions               
toTables :: [(String, a -> String)] [a] -> HtmlCode

toTable :: [(String, a -> String)] a -> HtmlCode